//
//  CMS_Users_Test.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 07/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
import XCTest
class CMS_Users_Test: XCTestCase {
    var memberGroups = [AnyObject]()



    func setUp() {
        super.setUp()
        var defaults = NSUserDefaults.standardUserDefaults()
        defaults.setObject("121", forKey: k_MemberID)
        defaults.setObject(["page1", "page2"], forKey: k_User_PagesBlacklist)
        var privilages = ["privilege1", "privilege2"]
        defaults.setObject(privilages, forKey: k_User_Privileges)
        var zones = ["zone1", "zone2"]
        defaults.setObject(zones, forKey: k_User_Zones)
        defaults.setObject("YES", forKey: k_isStaff)
        defaults.setObject("YES", forKey: k_isSuperAdmin)
        defaults.setObject("252", forKey: k_SessionID)
        defaults.setObject("testUser", forKey: k_Username)
        defaults.setObject("testPass", forKey: k_Password)
        memberGroups = [["name": "group1", "type": "testType"], ["name": "group2", "type": "testType"]]
        defaults.setObject(memberGroups, forKey: k_Members_Groups)
    }

    func tearDown() {
        // Put teardown code here. This method is called after the invocation of each test method in the class.
        super.tearDown()
    }

    func test_has_page_access() {
        XCTAssertTrue(CMS_Users.has_page_access("page3"), "")
        XCTAssertFalse(CMS_Users.has_page_access("page2"), "")
    }

    func test_has_privilege() {
        XCTAssertTrue(CMS_Users.has_privilege("privilege1"), "")
        XCTAssertTrue(CMS_Users.has_privilege("privilege2"), "")
        XCTAssertFalse(CMS_Users.has_privilege("privilege3"), "")
    }

    func test_has_zone_access() {
        XCTAssertTrue(CMS_Users.has_zone_access("zone1"), "")
        XCTAssertTrue(CMS_Users.has_zone_access("zone2"), "")
        XCTAssertFalse(CMS_Users.has_zone_access("zone3"), "")
    }

    func test_is_staff() {
        XCTAssertTrue(CMS_Users.is_staff(), "")
    }

    func test_is_super_admin() {
        XCTAssertFalse(CMS_Users.is_super_admin(), "")
    }

    func test_get_member() {
        XCTAssertEqual(CMS_Users.get_member(), 121, "")
    }

    func test_get_session_id() {
        XCTAssertEqual(CMS_Users.get_session_id(), 252, "")
    }

    func test_get_username() {
        XCTAssertTrue((CMS_Users.get_username() == "testUser"), "")
    }

    func test_get_members_groups() {
        XCTAssertTrue((CMS_Users.get_members_groups() as NSArray).isEqualToArray(memberGroups), "")
    }

    func test_get_members_groups_names() {
        XCTAssertTrue((CMS_Users.get_members_groups_names() as NSArray).isEqualToArray(CMS_Arrays.collapse_1d_complexity("name", memberGroups)), "")
    }

    func test_get_value() {
        CMS_Preferences.set_value("testKey", "testValue")
        XCTAssertTrue((CMS_Users.get_value("testKey") == "testValue"), "")
    }

    func test_get_password() {
        XCTAssertTrue((CMS_Users.get_password() == "testPass"), "")
    }
}